/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PlaneswalkersFuryEffect
extends OneShotEffect {
    PlaneswalkersFuryEffect() {
        super(Outcome.Damage);
        this.staticText = "Target opponent reveals a card at random from their hand. {this} deals damage equal to that card's mana value to that player";
    }

    private PlaneswalkersFuryEffect(PlaneswalkersFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null && !opponent.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            Card card = opponent.getHand().getRandom(game);
            if (card != null) {
                revealed.add(card);
                opponent.revealCards("Planeswalker's Fury", (Cards)revealed, game);
                opponent.damage(card.getManaValue(), source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public PlaneswalkersFuryEffect copy() {
        return new PlaneswalkersFuryEffect(this);
    }
}

