/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnFromExileEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.p.PlaneswalkersMischiefCastFromExileEffect;
import mage.cards.p.PlaneswalkersMischiefCondition;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PlaneswalkersMischiefEffect
extends OneShotEffect {
    PlaneswalkersMischiefEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent reveals a card at random from their hand. If it's an instant or sorcery card, exile it. You may cast it without paying its mana cost for as long as it remains exiled. At the beginning of the next end step, if you haven't cast it, return it to its owner's hand.";
    }

    private PlaneswalkersMischiefEffect(PlaneswalkersMischiefEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlaneswalkersMischiefEffect copy() {
        return new PlaneswalkersMischiefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (opponent != null && !opponent.getHand().isEmpty()) {
            Card revealedCard = opponent.getHand().getRandom(game);
            if (revealedCard == null) {
                return false;
            }
            CardsImpl cards = new CardsImpl(revealedCard);
            opponent.revealCards(source, (Cards)cards, game);
            if (revealedCard.isInstant(game) || revealedCard.isSorcery(game)) {
                opponent.moveCardToExileWithInfo(revealedCard, source.getSourceId(), "Planeswalker's Mischief", source, game, Zone.HAND, true);
                PlaneswalkersMischiefCastFromExileEffect effect = new PlaneswalkersMischiefCastFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(revealedCard.getId()));
                game.addEffect((ContinuousEffect)effect, source);
                ReturnFromExileEffect effect2 = new ReturnFromExileEffect(Zone.HAND);
                PlaneswalkersMischiefCondition condition = new PlaneswalkersMischiefCondition(source.getSourceId(), revealedCard.getId());
                ConditionalOneShotEffect effect3 = new ConditionalOneShotEffect((OneShotEffect)effect2, (Condition)condition, "if you haven't cast it, return it to its owner's hand.");
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect3);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                return true;
            }
        }
        return false;
    }
}

