/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class PlanetaryAnnihilationEffect
extends OneShotEffect {
    PlanetaryAnnihilationEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses six lands they control, then sacrifices the rest";
    }

    private PlanetaryAnnihilationEffect(PlanetaryAnnihilationEffect effect) {
        super((OneShotEffect)effect);
    }

    public PlanetaryAnnihilationEffect copy() {
        return new PlanetaryAnnihilationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet toSave = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LANDS, playerId, source, game) <= 6) continue;
            TargetPermanent target = new TargetPermanent(6, 6, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LANDS, true);
            target.withChooseHint("you will sacrifice the rest");
            player.choose(this.outcome, (Target)target, source, game);
            toSave.addAll(target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), source, game)) {
            if (toSave.contains(permanent)) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

