/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PlarggDeanOfChaosEffect
extends OneShotEffect {
    PlarggDeanOfChaosEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "reveal cards from the top of your library until you reveal a nonlegendary, nonland card with mana value 3 or less. You may cast that card without paying its mana cost. Put all revealed cards not cast this way on the bottom of your library in a random order";
    }

    private PlarggDeanOfChaosEffect(PlarggDeanOfChaosEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        boolean cardWasCast = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.getLibrary().hasCards()) {
            CardsImpl toReveal = new CardsImpl();
            Card eligibleCard = null;
            for (Card card : controller.getLibrary().getCards(game)) {
                toReveal.add(card);
                if (card.isLand(game) || card.isLegendary(game) || card.getManaValue() >= 4) continue;
                eligibleCard = card;
                break;
            }
            controller.revealCards(source, (Cards)toReveal, game);
            if (eligibleCard != null && controller.chooseUse(Outcome.PlayForFree, "Cast " + eligibleCard.getLogName() + " without paying its mana cost?", source, game)) {
                game.getState().setValue("PlayFromNotOwnHandZone" + eligibleCard.getId(), (Object)Boolean.TRUE);
                cardWasCast = controller.cast(controller.chooseAbilityForCast(eligibleCard, game, true), game, true, new ApprovingObject(source, game));
                game.getState().setValue("PlayFromNotOwnHandZone" + eligibleCard.getId(), null);
                if (cardWasCast) {
                    toReveal.remove(eligibleCard);
                }
            }
            controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        }
        return cardWasCast;
    }

    public PlarggDeanOfChaosEffect copy() {
        return new PlarggDeanOfChaosEffect(this);
    }
}

