/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.turn.AddExtraTurnControllerEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PleaForPowerEffect
extends OneShotEffect {
    PleaForPowerEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Will of the council</i> &mdash; Starting with you, each player votes for time or knowledge. If time gets more votes, take an extra turn after this one. If knowledge gets more votes or the vote is tied, draw three cards";
    }

    private PleaForPowerEffect(PleaForPowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PleaForPowerEffect copy() {
        return new PleaForPowerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Time (extra turn)", "Knowledge (draw 3 cards)", Outcome.Detriment);
        vote.doVotes(source, game);
        int timeCount = vote.getVoteCount((Object)true);
        int knowledgeCount = vote.getVoteCount((Object)false);
        if (timeCount > knowledgeCount) {
            return new AddExtraTurnControllerEffect().apply(game, source);
        }
        return controller.drawCards(3, source, game) > 0;
    }
}

