/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class PolukranosWorldEaterEffect
extends OneShotEffect {
    PolukranosWorldEaterEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals X damage divided as you choose among any number of target creatures your opponents control. Each of those creatures deals damage equal to its power to Polukranos";
    }

    private PolukranosWorldEaterEffect(PolukranosWorldEaterEffect effect) {
        super((OneShotEffect)effect);
    }

    public PolukranosWorldEaterEffect copy() {
        return new PolukranosWorldEaterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!source.getTargets().isEmpty()) {
            Target multiTarget = (Target)source.getTargets().get(0);
            HashSet<Permanent> permanents = new HashSet<Permanent>();
            for (UUID target : multiTarget.getTargets()) {
                Permanent permanent = game.getPermanent(target);
                if (permanent == null) continue;
                permanents.add(permanent);
                permanent.damage(multiTarget.getTargetAmount(target), source.getSourceId(), source, game, false, true);
            }
            Permanent sourceCreature = game.getPermanent(source.getSourceId());
            if (sourceCreature != null) {
                for (Permanent permanent : permanents) {
                    sourceCreature.damage(permanent.getPower().getValue(), permanent.getId(), source, game, false, true);
                }
            }
            return true;
        }
        return false;
    }
}

