/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class PolymorphEffect
extends OneShotEffect {
    PolymorphEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Its controller reveals cards from the top of their library until they reveal a creature card. The player puts that card onto the battlefield, then shuffles all other cards revealed this way into their library";
    }

    private PolymorphEffect(PolymorphEffect effect) {
        super((OneShotEffect)effect);
    }

    public PolymorphEffect copy() {
        return new PolymorphEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            Library library = player.getLibrary();
            if (library.hasCards()) {
                CardsImpl cards = new CardsImpl();
                Card toBattlefield = null;
                for (Card card : library.getCards(game)) {
                    cards.add(card);
                    if (!card.isCreature(game)) continue;
                    toBattlefield = card;
                    break;
                }
                if (toBattlefield != null) {
                    player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
                }
                player.revealCards(source, (Cards)cards, game);
                cards.remove(toBattlefield);
                if (!cards.isEmpty()) {
                    player.shuffleLibrary(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

