/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PoppetFactoryEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    PoppetFactoryEffect() {
        super(Duration.WhileOnBattlefield, Outcome.LoseAbility);
        this.staticText = "creature tokens you control lose all abilities and have base power and toughness 3/3";
    }

    private PoppetFactoryEffect(PoppetFactoryEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public PoppetFactoryEffect copy() {
        return new PoppetFactoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            switch (layer) {
                case AbilityAddingRemovingEffects_6: {
                    permanent.removeAllAbilities(source.getSourceId(), game);
                    break;
                }
                case PTChangingEffects_7: {
                    if (sublayer != SubLayer.SetPT_7b) break;
                    permanent.getPower().setModifiedBaseValue(3);
                    permanent.getToughness().setModifiedBaseValue(3);
                }
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.PTChangingEffects_7 || layer == Layer.AbilityAddingRemovingEffects_6;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
    }
}

