/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class PortalManipulatorEffect
extends OneShotEffect {
    PortalManipulatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target player and any number of target attacking creatures their opponents control. Those creatures are now attacking that player";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private PortalManipulatorEffect(PortalManipulatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public PortalManipulatorEffect copy() {
        return new PortalManipulatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(MageItem::getId).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        for (CombatGroup combatGroup : game.getCombat().getGroups()) {
            if (!combatGroup.getAttackers().stream().anyMatch(permanents::contains)) continue;
            combatGroup.changeDefenderPostDeclaration(player.getId(), game);
        }
        return true;
    }
}

