/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PossessedGoatEffect
extends ContinuousEffectImpl {
    PossessedGoatEffect() {
        super(Duration.Custom, Outcome.Benefit);
        this.staticText = "and it becomes a black Demon in addition to its other colors and types";
    }

    private PossessedGoatEffect(PossessedGoatEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public PossessedGoatEffect copy() {
        return new PossessedGoatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addSubType(game, new SubType[]{SubType.DEMON});
                return true;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setBlack(true);
                return true;
            }
        }
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case ColorChangingEffects_5: {
                return true;
            }
        }
        return false;
    }
}

