/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class PowerArtifactCostModificationEffect
extends CostModificationEffectImpl {
    PowerArtifactCostModificationEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Enchanted artifact's activated abilities cost {2} less to activate. This effect can't reduce the mana in that cost to less than one mana";
    }

    private PowerArtifactCostModificationEffect(PowerArtifactCostModificationEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Player controller = game.getPlayer(abilityToModify.getControllerId());
        if (controller != null) {
            int reduceMax = CardUtil.calculateActualPossibleGenericManaReduction((Mana)abilityToModify.getManaCostsToPay().getMana(), (int)2, (int)1);
            if (reduceMax <= 0) {
                return true;
            }
            CardUtil.reduceCost((Ability)abilityToModify, (int)reduceMax);
        }
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Permanent artifact = game.getPermanentOrLKIBattlefield(abilityToModify.getSourceId());
        return artifact != null && artifact.getAttachments().contains(source.getSourceId()) && abilityToModify.isActivatedAbility();
    }

    public PowerArtifactCostModificationEffect copy() {
        return new PowerArtifactCostModificationEffect(this);
    }
}

