/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class PowerPlantWorkerEffect
extends OneShotEffect {
    PowerPlantWorkerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "{this} gets +2/+2 until end of turn. If you control creatures named Mine Worker and Tower Worker, put two +1/+1 counters on {this} instead.";
    }

    private PowerPlantWorkerEffect(PowerPlantWorkerEffect effect) {
        super((OneShotEffect)effect);
    }

    public PowerPlantWorkerEffect copy() {
        return new PowerPlantWorkerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null) {
            return false;
        }
        String mineName = "Mine Worker";
        String towerName = "Tower Worker";
        boolean mine = false;
        boolean tower = false;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
            String name = permanent.getName();
            if (!mine && mineName.equals(name)) {
                mine = true;
            } else if (!tower && towerName.equals(name)) {
                tower = true;
            }
            if (!mine || !tower) continue;
            return sourcePermanent.addCounters(CounterType.P1P1.createInstance(2), source, game);
        }
        game.addEffect((ContinuousEffect)new BoostSourceEffect(2, 2, Duration.EndOfTurn), source);
        return true;
    }
}

