/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Card;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PraetorsGraspEffect
extends OneShotEffect {
    PraetorsGraspEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Search target opponent's library for a card and exile it face down. Then that player shuffles. You may look at and play that card for as long as it remains exiled";
    }

    private PraetorsGraspEffect(PraetorsGraspEffect effect) {
        super((OneShotEffect)effect);
    }

    public PraetorsGraspEffect copy() {
        return new PraetorsGraspEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && opponent != null && sourceObject != null) {
            TargetCardInLibrary target = new TargetCardInLibrary();
            if (controller.searchLibrary(target, source, game, opponent.getId())) {
                UUID targetId = target.getFirstTarget();
                Card card = opponent.getLibrary().getCard(targetId, game);
                if (card == null) {
                    return false;
                }
                new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(false, CastManaAdjustment.NONE).setTargetPointer((TargetPointer)new FixedTarget(card, game)).apply(game, source);
            }
            opponent.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

