/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class PrairieDogReplacementEffect
extends ReplacementEffectImpl {
    PrairieDogReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.BoostCreature, false);
        this.staticText = "Until end of turn, if you would put one or more +1/+1 counters on a creature you control, put that many plus one +1/+1 counters on it instead";
    }

    private PrairieDogReplacementEffect(PrairieDogReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PrairieDogReplacementEffect copy() {
        return new PrairieDogReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowInc((int)event.getAmount(), (int)1), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return event.getAmount() > 0 && source.isControlledBy(event.getPlayerId()) && permanent != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId()) && event.getData().equals(CounterType.P1P1.getName());
    }
}

