/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.condition.common.AddendumCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PrecognitivePerceptionEffect
extends OneShotEffect {
    PrecognitivePerceptionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw three cards.<br><i>Addendum</i> &mdash; If you cast this spell during your main phase, instead scry 3, then draw three cards.";
    }

    private PrecognitivePerceptionEffect(PrecognitivePerceptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrecognitivePerceptionEffect copy() {
        return new PrecognitivePerceptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (AddendumCondition.instance.apply(game, source)) {
            controller.scry(3, source, game);
        }
        controller.drawCards(3, source, game);
        return true;
    }
}

