/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class PreeminentCaptainEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("a soldier creature card");

    public PreeminentCaptainEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "put a Soldier creature card from your hand onto the battlefield tapped and attacking";
    }

    private PreeminentCaptainEffect(PreeminentCaptainEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        TargetCardInHand target = new TargetCardInHand((FilterCard)filter);
        if (controller != null && target.canChoose(controller.getId(), source, game) && target.choose(this.outcome, controller.getId(), source.getSourceId(), source, game)) {
            if (!target.getTargets().isEmpty()) {
                Permanent permanent;
                UUID cardId = target.getFirstTarget();
                Card card = controller.getHand().get(cardId, game);
                if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, true, null) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                    game.getCombat().addAttackingCreature(permanent.getId(), game);
                }
            }
            return true;
        }
        return false;
    }

    public PreeminentCaptainEffect copy() {
        return new PreeminentCaptainEffect(this);
    }

    static {
        filter.add((Predicate)SubType.SOLDIER.getPredicate());
    }
}

