/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class PrematureBurialWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> playerToETBMap = new HashMap<UUID, Set<MageObjectReference>>();

    public PrematureBurialWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent etbPermanent;
        if (event.getType() == GameEvent.EventType.END_TURN_STEP_POST) {
            this.playerToETBMap.put(event.getPlayerId(), new HashSet());
        } else if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && (etbPermanent = game.getPermanent(event.getTargetId())) != null) {
            for (UUID player : game.getPlayerList()) {
                if (!this.playerToETBMap.containsKey(player)) {
                    this.playerToETBMap.put(player, new HashSet());
                }
                this.playerToETBMap.get(player).add(new MageObjectReference(etbPermanent.getId(), game));
            }
        }
    }

    static boolean checkEnteredSinceLastTurn(UUID player, MageObjectReference mor, Game game) {
        return ((PrematureBurialWatcher)game.getState().getWatcher(PrematureBurialWatcher.class)).playerToETBMap.getOrDefault(player, Collections.emptySet()).contains(mor);
    }
}

