/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.players.Player;

class PriceOfProgressEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = FilterLandPermanent.nonbasicLands();

    public PriceOfProgressEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to each player equal to twice the number of nonbasic lands that player controls";
    }

    private PriceOfProgressEffect(PriceOfProgressEffect effect) {
        super((OneShotEffect)effect);
    }

    public PriceOfProgressEffect copy() {
        return new PriceOfProgressEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                int amount = game.getBattlefield().countAll((FilterPermanent)filter, playerId, game);
                if (amount <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.damage(amount * 2, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

