/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PrimalAmuletEffect
extends OneShotEffect {
    PrimalAmuletEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if there are four or more charge counters on it, you may remove those counters and transform it";
    }

    private PrimalAmuletEffect(PrimalAmuletEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrimalAmuletEffect copy() {
        return new PrimalAmuletEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || player == null || permanent.getCounters(game).getCount(CounterType.CHARGE) <= 3 || !player.chooseUse(Outcome.Benefit, "Remove all charge counters from this and transform it?", source, game)) {
            return false;
        }
        permanent.removeAllCounters(CounterType.CHARGE.getName(), source, game);
        permanent.transform(source, game);
        return true;
    }
}

