/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class PrimalEmpathyEffect
extends OneShotEffect {
    PrimalEmpathyEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if you control a creature with the greatest power among creatures on the battlefield. Otherwise, put a +1/+1 counter on a creature you control";
    }

    private PrimalEmpathyEffect(PrimalEmpathyEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrimalEmpathyEffect copy() {
        return new PrimalEmpathyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int highestPower = game.getBattlefield().getActivePermanents(source.getControllerId(), game).stream().filter(permanent1 -> permanent1.isCreature(game)).map(MageObject::getPower).mapToInt(MageInt::getValue).max().orElse(0);
        boolean flag = game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().filter(permanent1 -> permanent1.isCreature(game)).map(MageObject::getPower).mapToInt(MageInt::getValue).anyMatch(i -> i >= highestPower);
        if (flag) {
            return player.drawCards(1, source, game) > 0;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        return permanent != null && permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
    }
}

