/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.game.Game;
import mage.players.Player;

class PrimalOrderDamageTargetEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = FilterLandPermanent.nonbasicLands();

    public PrimalOrderDamageTargetEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to that player equal to the number of nonbasic lands they control";
    }

    private PrimalOrderDamageTargetEffect(PrimalOrderDamageTargetEffect copy) {
        super((OneShotEffect)copy);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null) {
            int damage = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, this.getTargetPointer().getFirst(game, source), game).size();
            player.damage(damage, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public PrimalOrderDamageTargetEffect copy() {
        return new PrimalOrderDamageTargetEffect(this);
    }
}

