/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.cards.Card;
import mage.cards.p.PrimordialMistCastFromExileEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PrimordialMistCost
extends CostImpl {
    TargetPermanent target;

    public PrimordialMistCost(TargetPermanent target) {
        this.target = target;
        this.text = "Exile a face-down permanent you control face up";
    }

    private PrimordialMistCost(PrimordialMistCost cost) {
        super((CostImpl)cost);
        this.target = cost.target.copy();
    }

    public PrimordialMistCost copy() {
        return new PrimordialMistCost(this);
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        return this.target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        Player controller = game.getPlayer(controllerId);
        if (controller != null && this.target.choose(Outcome.Exile, controllerId, source.getSourceId(), source, game)) {
            Permanent sourcePermanent;
            Card card = game.getCard(source.getSourceId());
            if (card != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
                Permanent targetPermanent = game.getPermanent(this.target.getFirstTarget());
                Card targetCard = game.getCard(this.target.getFirstTarget());
                if (targetPermanent != null && targetCard != null) {
                    String exileName = sourcePermanent.getIdName() + " <this card may be played the turn it was exiled>";
                    controller.moveCardsToExile((Card)targetPermanent, source, game, true, source.getSourceId(), exileName);
                    targetPermanent.setFaceDown(false, game);
                    PrimordialMistCastFromExileEffect effect = new PrimordialMistCastFromExileEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(targetCard.getId()));
                    game.addEffect((ContinuousEffect)effect, ability);
                    this.setPaid();
                }
            }
            this.setPaid();
            return true;
        }
        return false;
    }
}

