/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PrismaticBoonEffect
extends OneShotEffect {
    PrismaticBoonEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose a color. X target creatures gain protection from the chosen color until end of turn.";
    }

    private PrismaticBoonEffect(PrismaticBoonEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrismaticBoonEffect copy() {
        return new PrismaticBoonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor();
        if (!player.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)ProtectionAbility.from((ObjectColor)choice.getColor()), Duration.EndOfTurn), source);
        return true;
    }
}

