/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ColorsOfManaSpentToCastCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PrismaticEndingEffect
extends OneShotEffect {
    PrismaticEndingEffect() {
        super(Outcome.Benefit);
        this.staticText = "<i>Converge</i> &mdash; Exile target nonland permanent if its mana value is less than or equal to the number of colors of mana spent to cast this spell";
    }

    private PrismaticEndingEffect(PrismaticEndingEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrismaticEndingEffect copy() {
        return new PrismaticEndingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        int colors = ColorsOfManaSpentToCastCount.getInstance().calculate(game, source, (Effect)this);
        return player != null && permanent != null && permanent.getManaValue() <= colors && player.moveCards((Card)permanent, Zone.EXILED, source, game);
    }
}

