/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PrisonTermEffect
extends OneShotEffect {
    PrisonTermEffect() {
        super(Outcome.Detriment);
        this.staticText = "attach {this} to that creature";
    }

    private PrisonTermEffect(PrisonTermEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Permanent opponentCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent prisonTerm = game.getPermanent(source.getSourceId());
        if (you != null && opponentCreature != null && prisonTerm != null) {
            Permanent oldCreature = game.getPermanent(prisonTerm.getAttachedTo());
            if (oldCreature == null) {
                return false;
            }
            if (oldCreature.removeAttachment(prisonTerm.getId(), source, game)) {
                return opponentCreature.addAttachment(prisonTerm.getId(), source, game);
            }
        }
        return false;
    }

    public PrisonTermEffect copy() {
        return new PrisonTermEffect(this);
    }
}

