/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PrisonersDilemmaEffect
extends OneShotEffect {
    PrisonersDilemmaEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent secretly chooses silence or snitch, then the choices are revealed. If each opponent chose silence, {this} deals 4 damage to each of them. If each opponent chose snitch, {this} deals 8 damage to each of them. Otherwise, {this} deals 12 damage to each opponent who chose silence.";
    }

    private PrisonersDilemmaEffect(PrisonersDilemmaEffect effect) {
        super((OneShotEffect)effect);
    }

    public PrisonersDilemmaEffect copy() {
        return new PrisonersDilemmaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Player> silence = new ArrayList<Player>();
        ArrayList<Player> snitch = new ArrayList<Player>();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(playerId);
            if (opponent == null) continue;
            boolean choseSilence = opponent.chooseUse(Outcome.Vote, "Choose silence or snitch", null, "Silence", "Snitch", source, game);
            if (choseSilence) {
                silence.add(opponent);
                continue;
            }
            snitch.add(opponent);
        }
        for (Player player : snitch) {
            game.informPlayers(player.getName() + " chose snitch");
        }
        for (Player player : silence) {
            game.informPlayers(player.getName() + " chose silence");
        }
        if (snitch.isEmpty()) {
            for (Player player : silence) {
                player.damage(4, source.getSourceId(), source, game);
            }
        } else if (silence.isEmpty()) {
            for (Player player : snitch) {
                player.damage(8, source.getSourceId(), source, game);
            }
        } else {
            for (Player player : silence) {
                player.damage(12, source.getSourceId(), source, game);
            }
        }
        return true;
    }
}

