/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.common.EntersBattlefieldAllTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.watchers.common.CastFromGraveyardWatcher;

class PrizedAmalgamTriggerdAbility
extends EntersBattlefieldAllTriggeredAbility {
    PrizedAmalgamTriggerdAbility(Effect effect, FilterPermanent filter) {
        super(Zone.GRAVEYARD, effect, filter, false);
    }

    private PrizedAmalgamTriggerdAbility(PrizedAmalgamTriggerdAbility ability) {
        super((EntersBattlefieldAllTriggeredAbility)ability);
    }

    public PrizedAmalgamTriggerdAbility copy() {
        return new PrizedAmalgamTriggerdAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        boolean result = false;
        if (super.checkTrigger(event, game)) {
            CastFromGraveyardWatcher watcher;
            EntersTheBattlefieldEvent entersEvent = (EntersTheBattlefieldEvent)event;
            if (entersEvent.getFromZone() == Zone.GRAVEYARD) {
                result = true;
            } else if (entersEvent.getFromZone() == Zone.STACK && entersEvent.getTarget().isControlledBy(this.getControllerId()) && (watcher = (CastFromGraveyardWatcher)game.getState().getWatcher(CastFromGraveyardWatcher.class)) != null) {
                int zcc = game.getState().getZoneChangeCounter(event.getSourceId());
                result = watcher.spellWasCastFromGraveyard(event.getSourceId(), zcc - 1);
            }
        }
        if (result) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(this.getSourceId(), game.getState().getZoneChangeCounter(this.getSourceId())));
            }
        }
        return result;
    }

    public String getRule() {
        return "Whenever a creature enters the battlefield, if it entered from your graveyard or you cast it from your graveyard, return {this} from your graveyard to the battlefield tapped at the beginning of the next end step.";
    }
}

