/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.PhyrexianRebirthHorrorToken;
import mage.players.Player;
import mage.target.Target;

class ProfaneTransfusionEffect
extends OneShotEffect {
    ProfaneTransfusionEffect() {
        super(Outcome.Benefit);
        this.staticText = "You create an X/X colorless Phyrexian Horror artifact creature token, where X is the difference between those players' life totals";
    }

    private ProfaneTransfusionEffect(ProfaneTransfusionEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProfaneTransfusionEffect copy() {
        return new ProfaneTransfusionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (((Target)source.getTargets().get(0)).getTargets().size() < 2) {
            return false;
        }
        Player player1 = game.getPlayer((UUID)((Target)source.getTargets().get(0)).getTargets().get(0));
        Player player2 = game.getPlayer((UUID)((Target)source.getTargets().get(0)).getTargets().get(1));
        if (player1 == null || player2 == null) {
            return false;
        }
        int lifeDifference = Math.abs(player1.getLife() - player2.getLife());
        return new PhyrexianRebirthHorrorToken(lifeDifference, lifeDifference).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

