/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ProfanerOfTheDeadReturnEffect
extends OneShotEffect {
    ProfanerOfTheDeadReturnEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "return to their owners' hands all creatures your opponents control with toughness less than the exploited creature's toughness";
    }

    private ProfanerOfTheDeadReturnEffect(ProfanerOfTheDeadReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent exploitedCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller != null && exploitedCreature != null) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
            filter.add((Predicate)new ToughnessPredicate(ComparisonType.FEWER_THAN, exploitedCreature.getToughness().getValue()));
            CardsImpl cardsToHand = new CardsImpl();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
                cardsToHand.add((Card)permanent);
            }
            controller.moveCards((Cards)cardsToHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }

    public ProfanerOfTheDeadReturnEffect copy() {
        return new ProfanerOfTheDeadReturnEffect(this);
    }
}

