/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class ProfessorOnyxEffect
extends OneShotEffect {
    ProfessorOnyxEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may discard a card. If they don't, they lose 3 life. Repeat this process six more times";
    }

    private ProfessorOnyxEffect(ProfessorOnyxEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProfessorOnyxEffect copy() {
        return new ProfessorOnyxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (int i = 0; i < 6; ++i) {
            Player player;
            HashMap<UUID, Card> playerMap = new HashMap<UUID, Card>();
            for (UUID playerId : game.getOpponents(source.getControllerId())) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                TargetDiscard target = new TargetDiscard(0, 1, StaticFilters.FILTER_CARD, playerId);
                player.choose(Outcome.Discard, (Target)target, source, game);
                playerMap.put(playerId, game.getCard(target.getFirstTarget()));
            }
            for (UUID playerId : game.getOpponents(source.getControllerId())) {
                player = game.getPlayer(playerId);
                if (player == null || playerMap.get(playerId) != null && player.discard((Card)playerMap.get(playerId), false, source, game)) continue;
                player.loseLife(3, game, source, false);
            }
        }
        return true;
    }
}

