/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ProgenitorsIconWatcher
extends Watcher {
    private final Map<UUID, Set<SubType>> playerSubTypesChosen = new HashMap<UUID, Set<SubType>>();

    public ProgenitorsIconWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            Spell spell = game.getSpellOrLKIStack(event.getSourceId());
            Set<SubType> chosenSubTypes = this.playerSubTypesChosen.get(event.getPlayerId());
            if (spell == null || chosenSubTypes == null) {
                return;
            }
            for (SubType subType : spell.getSubtype()) {
                chosenSubTypes.remove(subType);
            }
        }
    }

    public static void addPlayer(UUID playerId, SubType subtype, Game game) {
        ((ProgenitorsIconWatcher)game.getState().getWatcher(ProgenitorsIconWatcher.class)).playerSubTypesChosen.computeIfAbsent(playerId, x -> new HashSet()).add(subtype);
    }

    public static boolean checkPlayerCast(UUID playerId, SubType subtype, Game game) {
        return ((ProgenitorsIconWatcher)game.getState().getWatcher(ProgenitorsIconWatcher.class)).playerSubTypesChosen.getOrDefault(playerId, Collections.emptySet()).contains(subtype);
    }

    public void reset() {
        super.reset();
        this.playerSubTypesChosen.clear();
    }
}

