/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ProphecyEffect
extends OneShotEffect {
    ProphecyEffect() {
        super(Outcome.GainLife);
        this.staticText = "Reveal the top card of target opponent's library. If it's a land, you gain 1 life. Then that player shuffles";
    }

    private ProphecyEffect(ProphecyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProphecyEffect copy() {
        return new ProphecyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject == null || targetPlayer == null || controller == null) {
            return false;
        }
        if (targetPlayer.getLibrary().hasCards()) {
            CardsImpl cards = new CardsImpl();
            Card card = targetPlayer.getLibrary().getFromTop(game);
            if (card == null) {
                return false;
            }
            cards.add(card);
            targetPlayer.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (card.isLand(game)) {
                controller.gainLife(1, game, source);
            }
            targetPlayer.shuffleLibrary(source, game);
        }
        return true;
    }
}

