/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.p.PropheticFlamespeakerCastFromExileEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class PropheticFlamespeakerExileEffect
extends OneShotEffect {
    PropheticFlamespeakerExileEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile the top card of your library. You may play it this turn";
    }

    private PropheticFlamespeakerExileEffect(PropheticFlamespeakerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public PropheticFlamespeakerExileEffect copy() {
        return new PropheticFlamespeakerExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null && controller.moveCardsToExile(card, source, game, true, source.getSourceId(), CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, (String)"<this card may be played the turn it was exiled>"))) {
                PropheticFlamespeakerCastFromExileEffect effect = new PropheticFlamespeakerCastFromExileEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

