/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.condition.common.DeliriumCondition;
import mage.abilities.dynamicvalue.common.CardTypesInGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.LookLibraryAndPickControllerEffect;
import mage.constants.AbilityWord;
import mage.constants.PutCards;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class PropheticTitanTriggeredAbility
extends EntersBattlefieldTriggeredAbility {
    public PropheticTitanTriggeredAbility() {
        super((Effect)new DamageTargetEffect(4), false);
        this.addMode(new Mode((Effect)new LookLibraryAndPickControllerEffect(4, 1, PutCards.HAND, PutCards.BOTTOM_RANDOM)));
        this.getModes().setChooseText("choose one. If there are four or more card types among cards in your graveyard, choose both instead.");
        this.addTarget((Target)new TargetAnyTarget());
        this.addHint(CardTypesInGraveyardCount.YOU.getHint());
        this.setAbilityWord(AbilityWord.DELIRIUM);
    }

    private PropheticTitanTriggeredAbility(PropheticTitanTriggeredAbility ability) {
        super((EntersBattlefieldTriggeredAbility)ability);
    }

    public PropheticTitanTriggeredAbility copy() {
        return new PropheticTitanTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!super.checkTrigger(event, game)) {
            return false;
        }
        int modes = DeliriumCondition.instance.apply(game, (Ability)this) ? 2 : 1;
        this.getModes().setMinModes(modes);
        this.getModes().setMaxModes(modes);
        return true;
    }
}

