/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactOrEnchantmentPermanent;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class ProtectorOfTheWastesTarget
extends TargetPermanent {
    private static final FilterArtifactOrEnchantmentPermanent filter = new FilterArtifactOrEnchantmentPermanent("artifacts and/or enchantments controlled by different players");

    ProtectorOfTheWastesTarget() {
        super(0, 2, (FilterPermanent)filter);
    }

    private ProtectorOfTheWastesTarget(ProtectorOfTheWastesTarget target) {
        super((TargetPermanent)target);
    }

    public ProtectorOfTheWastesTarget copy() {
        return new ProtectorOfTheWastesTarget(this);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        Set usedControllers = this.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).map(Controllable::getControllerId).collect(Collectors.toSet());
        possibleTargets.removeIf(id -> {
            Permanent permanent = game.getPermanent(id);
            return permanent == null || usedControllers.contains(permanent.getControllerId());
        });
        return possibleTargets;
    }
}

