/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ProwlingPangolinEffect
extends OneShotEffect {
    ProwlingPangolinEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "any player may sacrifice two creatures of their choice. If a player does, sacrifice {this}";
    }

    private ProwlingPangolinEffect(ProwlingPangolinEffect effect) {
        super((OneShotEffect)effect);
    }

    public ProwlingPangolinEffect copy() {
        return new ProwlingPangolinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourceObject;
            boolean costPaid = false;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                SacrificeTargetCost cost = new SacrificeTargetCost(2, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES);
                Player player = game.getPlayer(playerId);
                if (player == null || !cost.canPay(source, source, playerId, game) || !player.chooseUse(Outcome.Sacrifice, "Sacrifice two creatures?", source, game) || !cost.pay(source, game, source, playerId, true, null)) continue;
                costPaid = true;
            }
            if (costPaid && (sourceObject = game.getPermanent(source.getSourceId())) != null) {
                sourceObject.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

