/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.NymphToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class PsemillaMeletianPoetTriggeredAbility
extends TriggeredAbilityImpl {
    PsemillaMeletianPoetTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new NymphToken()));
        this.setTriggerPhrase("Whenever you cast your first enchantment spell each turn, ");
    }

    private PsemillaMeletianPoetTriggeredAbility(PsemillaMeletianPoetTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PsemillaMeletianPoetTriggeredAbility copy() {
        return new PsemillaMeletianPoetTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !spell.isEnchantment(game)) {
            return false;
        }
        List spells = ((SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class)).getSpellsCastThisTurn(this.getControllerId()).stream().filter(s -> s.isEnchantment(game)).collect(Collectors.toList());
        return spells.size() == 1 && ((Spell)spells.get(0)).getId().equals(event.getTargetId());
    }
}

