/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class PsychicPossessionTriggeredAbility
extends TriggeredAbilityImpl {
    public PsychicPossessionTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
    }

    private PsychicPossessionTriggeredAbility(PsychicPossessionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PsychicPossessionTriggeredAbility copy() {
        return new PsychicPossessionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DREW_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanent(this.sourceId);
        if (enchantment != null && enchantment.getAttachedTo() != null) {
            Player opponent = game.getPlayer(enchantment.getAttachedTo());
            Player player = game.getPlayer(event.getPlayerId());
            if (opponent != null && player != null && Objects.equals(player, opponent)) {
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever enchanted opponent draws a card, you may draw a card.";
    }
}

