/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class PsychicTheftWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> map = new HashMap<UUID, Set<MageObjectReference>>();

    PsychicTheftWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || spell.getCard() == null || spell.getCard().getMainCard() == null) {
            return;
        }
        this.map.computeIfAbsent(event.getPlayerId(), x -> new HashSet()).add(new MageObjectReference((MageObject)spell.getCard().getMainCard(), game));
    }

    boolean checkPlayer(UUID playerId, MageObjectReference mor) {
        return this.map.computeIfAbsent(playerId, x -> new HashSet()).contains(mor);
    }
}

