/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class PucasMischiefSecondTarget
extends TargetPermanent {
    public PucasMischiefSecondTarget() {
        super((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_NON_LAND);
        this.withTargetName("permanent an opponent controls with an equal or lesser mana value");
    }

    private PucasMischiefSecondTarget(PucasMischiefSecondTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID id, Ability source, Game game) {
        Permanent ownPermanent = game.getPermanent(source.getFirstTarget());
        Permanent possiblePermanent = game.getPermanent(id);
        if (ownPermanent == null || possiblePermanent == null) {
            return false;
        }
        return super.canTarget(id, source, game) && ownPermanent.getManaValue() >= possiblePermanent.getManaValue();
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Permanent ownPermanent = game.getPermanent(source.getFirstTarget());
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
            if (ownPermanent == null) {
                possibleTargets.add(permanent.getId());
                continue;
            }
            if (ownPermanent.getManaValue() < permanent.getManaValue()) continue;
            possibleTargets.add(permanent.getId());
        }
        possibleTargets.removeIf(id -> ownPermanent != null && ownPermanent.getId().equals(id));
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        return super.chooseTarget(Outcome.GainControl, playerId, source, game);
    }

    public PucasMischiefSecondTarget copy() {
        return new PucasMischiefSecondTarget(this);
    }
}

