/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class PulseOfTheTangleReturnToHandEffect
extends OneShotEffect {
    PulseOfTheTangleReturnToHandEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then if an opponent controls more creatures than you, return {this} to its owner's hand";
    }

    private PulseOfTheTangleReturnToHandEffect(PulseOfTheTangleReturnToHandEffect effect) {
        super((OneShotEffect)effect);
    }

    public PulseOfTheTangleReturnToHandEffect copy() {
        return new PulseOfTheTangleReturnToHandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        FilterControlledCreaturePermanent controllerFilter = new FilterControlledCreaturePermanent();
        PermanentsOnBattlefieldCount controllerCount = new PermanentsOnBattlefieldCount((FilterPermanent)controllerFilter);
        int controllerAmount = controllerCount.calculate(game, source, (Effect)this);
        boolean check = false;
        if (controller != null) {
            for (UUID opponentID : game.getOpponents(controller.getId())) {
                if (opponentID == null) continue;
                FilterCreaturePermanent opponentFilter = new FilterCreaturePermanent();
                opponentFilter.add((Predicate)new ControllerIdPredicate(opponentID));
                PermanentsOnBattlefieldCount opponentCreatureCount = new PermanentsOnBattlefieldCount((FilterPermanent)opponentFilter);
                check = opponentCreatureCount.calculate(game, source, (Effect)this) > controllerAmount;
                if (!check) continue;
                break;
            }
            if (check) {
                Card card = game.getCard(source.getSourceId());
                controller.moveCards(card, Zone.HAND, source, game);
                return true;
            }
        }
        return false;
    }
}

