/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class PuresightMerrowEffect
extends OneShotEffect {
    PuresightMerrowEffect() {
        super(Outcome.Detriment);
        this.staticText = "Look at the top card of your library. You may exile that card";
    }

    private PuresightMerrowEffect(PuresightMerrowEffect effect) {
        super((OneShotEffect)effect);
    }

    public PuresightMerrowEffect copy() {
        return new PuresightMerrowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            controller.lookAtCards("Puresight Merrow", (Cards)cards, game);
            if (controller.chooseUse(Outcome.Removal, "Exile the card from the top of your library?", source, game)) {
                controller.moveCardToExileWithInfo(card, source.getSourceId(), sourceObject.getIdName(), source, game, Zone.LIBRARY, true);
            } else {
                game.informPlayers(controller.getLogName() + " puts the card back on top of their library.");
            }
            return true;
        }
        return false;
    }
}

