/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class PurgatoryExileEffect
extends OneShotEffect {
    PurgatoryExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile that card";
    }

    private PurgatoryExileEffect(PurgatoryExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourceController = game.getPlayer(source.getControllerId());
        UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
        MageObject sourceObject = source.getSourceObject(game);
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (sourceController != null && exileId != null && sourceObject != null && card != null) {
            if (game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
                sourceController.moveCardsToExile(card, source, game, true, exileId, sourceObject.getIdName());
            }
            return true;
        }
        return false;
    }

    public PurgatoryExileEffect copy() {
        return new PurgatoryExileEffect(this);
    }
}

