/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.p.PurgatoryExileEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PurgatoryTriggeredAbility
extends TriggeredAbilityImpl {
    PurgatoryTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new PurgatoryExileEffect(), false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private PurgatoryTriggeredAbility(PurgatoryTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public PurgatoryTriggeredAbility copy() {
        return new PurgatoryTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        Permanent permanent;
        Player controller;
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (sourcePermanent != null && (controller = game.getPlayer(sourcePermanent.getControllerId())) != null && (permanent = (zEvent = (ZoneChangeEvent)event).getTarget()) != null && zEvent.isDiesEvent() && !(permanent instanceof PermanentToken) && permanent.isCreature(game) && permanent.isOwnedBy(controller.getId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a nontoken creature is put into your graveyard from the battlefield, exile that card.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

