/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class PyramidsEffect
extends ReplacementEffectImpl {
    PyramidsEffect() {
        super(Duration.EndOfTurn, Outcome.Regenerate);
        this.staticText = "the next time target land would be destroyed this turn, remove all damage marked on it instead";
    }

    private PyramidsEffect(PyramidsEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public PyramidsEffect copy() {
        return new PyramidsEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.removeAllDamage(game);
        this.used = true;
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return GameEvent.EventType.DESTROY_PERMANENT == event.getType();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source)) && !this.used;
    }
}

