/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class PyreticChargeEffect
extends OneShotEffect {
    PyreticChargeEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard your hand, then draw four cards. For each card discarded this way, creatures you control get +1/+0 until end of turn";
    }

    private PyreticChargeEffect(PyreticChargeEffect effect) {
        super((OneShotEffect)effect);
    }

    public PyreticChargeEffect copy() {
        return new PyreticChargeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int count = player.getHand().size();
        player.discard(count, false, false, source, game);
        player.drawCards(4, source, game);
        game.addEffect((ContinuousEffect)new BoostControlledEffect(count, 0, Duration.EndOfTurn), source);
        return true;
    }
}

