/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.p;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.common.FilterInstantOrSorcerySpell;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class PyromancersGogglesTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterInstantOrSorcerySpell filter = new FilterInstantOrSorcerySpell();
    String abilityOriginalId;

    public PyromancersGogglesTriggeredAbility(UUID abilityOriginalId, Effect effect) {
        super(Zone.ALL, effect, false);
        this.abilityOriginalId = abilityOriginalId.toString();
        this.setTriggerPhrase("When that mana is used to cast a red instant or sorcery spell, ");
    }

    private PyromancersGogglesTriggeredAbility(PyromancersGogglesTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.abilityOriginalId = ability.abilityOriginalId;
    }

    public PyromancersGogglesTriggeredAbility copy() {
        return new PyromancersGogglesTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_PAID;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        if (event.getData().equals(this.abilityOriginalId) && (spell = game.getStack().getSpell(event.getTargetId())) != null && filter.match((StackObject)spell, this.getControllerId(), (Ability)this, game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
    }
}

