/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.q.QueenKaylaBinKroogTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class QueenKaylaBinKroogEffect
extends OneShotEffect {
    QueenKaylaBinKroogEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard all the cards in your hand, then draw that many cards. You may choose an artifact or creature card with mana value 1 you discarded this way, then do the same for artifact or creature cards with mana values 2 and 3. Return those cards to the battlefield";
    }

    private QueenKaylaBinKroogEffect(QueenKaylaBinKroogEffect effect) {
        super((OneShotEffect)effect);
    }

    public QueenKaylaBinKroogEffect copy() {
        return new QueenKaylaBinKroogEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        Cards cards = player.discard(player.getHand(), false, source, game);
        player.drawCards(cards.size(), source, game);
        QueenKaylaBinKroogTarget target = new QueenKaylaBinKroogTarget();
        player.choose(this.outcome, cards, (TargetCard)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        return true;
    }
}

