/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.LoseAbilityAllEffect;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;

class QuickDrawEffect
extends OneShotEffect {
    QuickDrawEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Creatures target opponent controls lose first strike and double strike until end of turn.";
    }

    private QuickDrawEffect(QuickDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuickDrawEffect copy() {
        return new QuickDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
        game.addEffect((ContinuousEffect)new LoseAbilityAllEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter), source);
        game.addEffect((ContinuousEffect)new LoseAbilityAllEffect((Ability)DoubleStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter), source);
        return true;
    }
}

