/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.target.Target;

class QuicksilverDragonEffect
extends OneShotEffect {
    QuicksilverDragonEffect() {
        super(Outcome.Benefit);
        this.staticText = "If target spell has only one target and that target is {this}, change that spell's target to another creature";
    }

    private QuicksilverDragonEffect(QuicksilverDragonEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuicksilverDragonEffect copy() {
        return new QuicksilverDragonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            int numTargets = 0;
            for (Target target : spell.getSpellAbility().getTargets()) {
                numTargets += target.getTargets().size();
            }
            if (numTargets == 1 && spell.getSpellAbility().getTargets().getFirstTarget().equals(source.getSourceId())) {
                spell.chooseNewTargets(game, source.getControllerId(), true, false, null);
            }
            return true;
        }
        return false;
    }
}

